<?php
require_once __DIR__ . '/config.php';
require_once __DIR__ . '/db.php';
require_once __DIR__ . '/auth.php';

// Set execution time limit
set_time_limit(60);

if(!isset($_SESSION['user'])){ die('Требуется авторизация'); }
$login = $_SESSION['user']['login'] ?? '';
$admins = ADMIN_LOGINS;
if(!in_array($login, $admins, true)){ die('Доступ запрещен'); }

$post_id = isset($_POST['post_id']) ? intval($_POST['post_id']) : null;
$title = trim($_POST['title'] ?? '');
$category_id = trim($_POST['category_id'] ?? '');
$new_category = trim($_POST['new_category'] ?? '');
$tags = trim($_POST['tags'] ?? '');
$content_html = $_POST['content_html'] ?? '';
$uploaded_files = json_decode($_POST['uploaded_files'] ?? '[]', true);

if($title === '') die('Заголовок обязателен');

try {
    if($new_category !== ''){
        $slug = slugify($new_category);
        $st = $db->prepare("INSERT INTO categories(name, slug) VALUES(?, ?)");
        $st->execute([$new_category, $slug]);
        $category_id = $db->lastInsertId();
    } else {
        if($category_id === '') $category_id = null;
    }

    // Check if we're updating an existing post or creating a new one
    if ($post_id) {
        // Update existing post
        $stmt = $db->prepare("SELECT slug FROM posts WHERE id = ?");
        $stmt->execute([$post_id]);
        $existing_post = $stmt->fetch();
        
        if (!$existing_post) {
            die('Post not found');
        }
        
        // Keep the original slug for existing posts
        $slug = $existing_post['slug'];
        
        $st = $db->prepare("UPDATE posts SET title=?, content_html=?, category_id=?, created_at=created_at WHERE id=?");
        $st->execute([$title, $content_html, $category_id, $post_id]);
        
        // Delete existing tag associations (we'll recreate them)
        $db->prepare("DELETE FROM post_tags WHERE post_id=?")->execute([$post_id]);
    } else {
        // Create new post
        $slug = slugify($title) . '-' . substr(md5(uniqid('', true)), 0, 6);
        $st = $db->prepare("INSERT INTO posts(title, slug, content_html, user_id, u_login, category_id, created_at) VALUES(?, ?, ?, ?, ?, ?, NOW())");
        $u_login = $login;
        $u_id = null;
        $st->execute([$title, $slug, $content_html, $u_id, $u_login, $category_id]);
        $post_id = $db->lastInsertId();
    }

    // Handle tags for both new and existing posts
    if($tags !== ''){
        $parts = array_filter(array_map('trim', explode(',', $tags)));
        foreach($parts as $t){
            $st = $db->prepare("SELECT id FROM tags WHERE name=?");
            $st->execute([$t]);
            $row = $st->fetch();
            if(!$row){
                $db->prepare("INSERT INTO tags(name, slug) VALUES(?, ?)")->execute([$t, slugify($t)]);
                $tag_id = $db->lastInsertId();
            } else { $tag_id = $row['id']; }
            $db->prepare("INSERT IGNORE INTO post_tags(post_id, tag_id) VALUES(?, ?)")->execute([$post_id, $tag_id]);
        }
    }

    // Handle existing attachments reordering
    $existing_attachments_order = json_decode($_POST['existing_attachments_order'] ?? '[]', true);
    if (is_array($existing_attachments_order)) {
        foreach ($existing_attachments_order as $attachment_order) {
            if (isset($attachment_order['id']) && isset($attachment_order['sort_order'])) {
                $db->prepare("UPDATE attachments SET sort_order = ? WHERE id = ? AND post_id = ?")
                   ->execute([intval($attachment_order['sort_order']), intval($attachment_order['id']), $post_id]);
            }
        }
    }

    // Handle attachments for both new and existing posts
    if(is_array($uploaded_files)){
        foreach($uploaded_files as $f){
            if(!isset($f['filename'])) continue;
            $sort_order = isset($f['sort_order']) ? intval($f['sort_order']) : 0;
            
            // Try to insert with sort_order, fallback without if column doesn't exist
            try {
                $db->prepare("INSERT INTO attachments(post_id, filename, original_name, mime, size, sort_order, uploaded_at) VALUES(?, ?, ?, ?, ?, ?, NOW())")
                   ->execute([$post_id, $f['filename'], $f['original_name'] ?? '', $f['mime'] ?? '', intval($f['size'] ?? 0), $sort_order]);
            } catch (PDOException $e) {
                // If sort_order column doesn't exist, fallback to insert without it
                if (strpos($e->getMessage(), 'sort_order') !== false) {
                    $db->prepare("INSERT INTO attachments(post_id, filename, original_name, mime, size, uploaded_at) VALUES(?, ?, ?, ?, ?, NOW())")
                       ->execute([$post_id, $f['filename'], $f['original_name'] ?? '', $f['mime'] ?? '', intval($f['size'] ?? 0)]);
                } else {
                    throw $e;
                }
            }
        }
    }
    
    header("Location: post.php?slug=" . urlencode($slug));
    exit;
} catch (Exception $e) {
    error_log("Error saving post: " . $e->getMessage());
    die("Error saving post: " . htmlspecialchars($e->getMessage()));
}